VERSION 5.00
Begin VB.Form frmDemo 
   AutoRedraw      =   -1  'True
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Australia Post 4-state barcode"
   ClientHeight    =   5964
   ClientLeft      =   36
   ClientTop       =   612
   ClientWidth     =   8724
   FillColor       =   &H80000008&
   LinkTopic       =   "Form1"
   ScaleHeight     =   5964
   ScaleWidth      =   8724
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton Cmd_FCC 
      BackColor       =   &H008080FF&
      Height          =   255
      Left            =   4320
      Picture         =   "Demo.frx":0000
      Style           =   1  'Graphical
      TabIndex        =   26
      Top             =   600
      Width           =   255
   End
   Begin VB.ListBox Lst_FCC 
      BackColor       =   &H00FFFFFF&
      Height          =   624
      ItemData        =   "Demo.frx":030A
      Left            =   360
      List            =   "Demo.frx":0317
      TabIndex        =   24
      Top             =   840
      Visible         =   0   'False
      Width           =   3975
   End
   Begin VB.CommandButton cmdStep 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Step Build"
      Height          =   372
      Left            =   360
      TabIndex        =   23
      Top             =   2160
      Width           =   972
   End
   Begin VB.TextBox txtUserInfo2 
      Height          =   288
      Left            =   5040
      Locked          =   -1  'True
      TabIndex        =   22
      Top             =   1080
      Width           =   2895
   End
   Begin VB.PictureBox PicBC 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00FFFFFF&
      Height          =   900
      Left            =   360
      ScaleHeight     =   852
      ScaleWidth      =   8004
      TabIndex        =   21
      Top             =   4680
      Width           =   8055
   End
   Begin VB.TextBox txtDPID 
      BackColor       =   &H00FFFFC0&
      Height          =   288
      Left            =   5040
      MaxLength       =   8
      TabIndex        =   20
      Top             =   600
      Width           =   855
   End
   Begin VB.CommandButton cmdClear 
      Caption         =   "Clear"
      Height          =   372
      Left            =   360
      TabIndex        =   19
      Top             =   2880
      Width           =   972
   End
   Begin VB.TextBox txtBCStr 
      Height          =   288
      Left            =   360
      Locked          =   -1  'True
      TabIndex        =   18
      Top             =   4320
      Width           =   8055
   End
   Begin VB.TextBox txt8 
      Height          =   288
      Left            =   6600
      Locked          =   -1  'True
      TabIndex        =   17
      Top             =   3840
      Width           =   1332
   End
   Begin VB.TextBox txtStopDigits 
      Height          =   288
      Left            =   8040
      Locked          =   -1  'True
      TabIndex        =   16
      Top             =   3840
      Width           =   372
   End
   Begin VB.TextBox txtStartDigits 
      Height          =   288
      Left            =   360
      Locked          =   -1  'True
      TabIndex        =   15
      Top             =   3840
      Width           =   372
   End
   Begin VB.TextBox txt7 
      Height          =   288
      Left            =   6600
      Locked          =   -1  'True
      TabIndex        =   14
      Top             =   3120
      Width           =   1815
   End
   Begin VB.TextBox txt6 
      Height          =   288
      Left            =   5040
      Locked          =   -1  'True
      TabIndex        =   13
      Top             =   3120
      Width           =   1335
   End
   Begin VB.TextBox txtRS 
      Alignment       =   2  'Center
      BackColor       =   &H00C00000&
      ForeColor       =   &H00FFFFFF&
      Height          =   372
      Left            =   2400
      Locked          =   -1  'True
      TabIndex        =   12
      Text            =   "Reed Solomon Algorithm"
      Top             =   3120
      Width           =   1932
   End
   Begin VB.TextBox txt5 
      Height          =   288
      Left            =   2400
      Locked          =   -1  'True
      TabIndex        =   11
      Top             =   2640
      Width           =   6015
   End
   Begin VB.TextBox Txt4 
      Height          =   288
      Left            =   2400
      Locked          =   -1  'True
      TabIndex        =   10
      Top             =   2040
      Width           =   6015
   End
   Begin VB.TextBox txt3 
      Height          =   288
      Left            =   2400
      Locked          =   -1  'True
      TabIndex        =   9
      Top             =   1560
      Width           =   6015
   End
   Begin VB.TextBox txtPadding2 
      Height          =   288
      Left            =   8160
      Locked          =   -1  'True
      TabIndex        =   8
      Top             =   1080
      Width           =   252
   End
   Begin VB.CommandButton cmdBuild 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Quick Build"
      Height          =   372
      Left            =   360
      TabIndex        =   7
      Top             =   1440
      Width           =   972
   End
   Begin VB.TextBox txtDPID2 
      BackColor       =   &H00FFFFFF&
      Height          =   288
      Left            =   3360
      Locked          =   -1  'True
      TabIndex        =   6
      Top             =   1080
      Width           =   1572
   End
   Begin VB.TextBox txtFCC2 
      Height          =   288
      Left            =   2400
      Locked          =   -1  'True
      TabIndex        =   5
      Top             =   1080
      Width           =   492
   End
   Begin VB.TextBox txtUserInfo 
      BackColor       =   &H00C0C0C0&
      Enabled         =   0   'False
      Height          =   288
      Left            =   6360
      MaxLength       =   10
      TabIndex        =   4
      ToolTipText     =   "This field is C table encode. This allows characters to be entered as well as digits."
      Top             =   600
      Width           =   1575
   End
   Begin VB.TextBox txt9 
      Height          =   288
      Left            =   960
      Locked          =   -1  'True
      TabIndex        =   2
      Top             =   3840
      Width           =   5412
   End
   Begin VB.Label Lbl_FCC 
      BackColor       =   &H00FFFFC0&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Label3"
      Height          =   255
      Left            =   360
      TabIndex        =   25
      Top             =   600
      Width           =   3975
   End
   Begin VB.Label Label4 
      Caption         =   "User Information "
      Height          =   255
      Left            =   6600
      TabIndex        =   3
      Top             =   240
      Width           =   1215
   End
   Begin VB.Label Label2 
      Caption         =   "Sorting Code (DPID)"
      Height          =   375
      Left            =   5040
      TabIndex        =   1
      ToolTipText     =   "Sorting Code (DPID)"
      Top             =   120
      Width           =   975
   End
   Begin VB.Label Label1 
      Caption         =   "Format Control Code "
      Height          =   255
      Left            =   600
      TabIndex        =   0
      Top             =   240
      Width           =   3015
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuAbout 
         Caption         =   "About"
      End
   End
End
Attribute VB_Name = "frmDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'---------------------------------------------------------------------------
' Title    : Australia Post Barcode Demonstration
' Version  : R2
' Date     : 5th March 1999.
' Language : Visual Basic V5 (or higher)
'
' Description
' -----------
' This software module produces 4-states barcode
' digits with Reed-Solomon error detection and
' correction algorithm.
'
' It demonstrates barcode generation. The user
' enters data for the Format Control Code, the
' sorting code and optionally, a User Information
' String.  It then proceeds to validate input and
' generate the barcode string.
'
' Disclaimer
' ----------
' Whilst Australia Post provides this program in good faith, no
' responsibility is taken as to its accuracy. The program is
' provided for guidance only. Australia Post shall not be liable
' for any loss or damage arising from the use of, or reliance placed
' on, any information provided by it.
'
' History    By     Ref    Description
' --------   ---    ---    ------------------------------------------
' 02/03/99   DM     R2     Original version.
'---------------------------------------------------------------------------

Option Explicit

#Const MDL_PRESENTANTION_VERSION = True

'For the PRESENTATION VERSION and DEMO VERSION
'use #if MDL_PRESENTANTION_VERSION then ..... and #endif

'Barcode encoding tables. See sub initialise()
Dim Mdl_NTable As String                'Dim Mdl_NTable(0 To 9) As String
Dim Mdl_ZTable(65 To 90) As String
Dim Mdl_BarTable(0 To 63) As String
Dim Mdl_CTable As String

'User input variables
Dim ui_params As UI_paramaters

'Format control code variables.
Const gbl_FCC_val_11 As String = "Standard Customer "
Const gbl_FCC_val_59 As String = "Customer Barcode 2"
Const gbl_FCC_val_62 As String = "Customer Barcode 3"

' G3 to integer encoding. Used for RS-ECB calculations
Dim ICodeWord(0 To 99) As Integer
' Number of G3 to decimal encoded Symbols
Dim nCodeWord As Integer

'Dim BStep As Integer

' Global variables: The multiplication table for
' Galois field arithmetic and the generator
' polynomial, g(x)

Dim mult(0 To 63, 0 To 63) As Integer
Dim gen(0 To 4) As Integer
    
Function ConvertC(inpStr As String)
'Convert the string to c table encoded digits.
    
    Dim i As Integer
    Dim x As Integer
    Dim lcl_tmp As Integer
    Dim iLen As Integer
    Dim outStr As String
    outStr = ""
    
    'Define carriage return line feed
    Dim CRLF As String
    CRLF = Chr$(13) & Chr$(10)
    
    'No longer use the input variable,  as it has been modified.
    inpStr = txtUserInfo.Text
    iLen = Len(inpStr)
    
    'Get string characters one by one and build output string.
    For i = 1 To iLen
        
        lcl_tmp = Asc(Mid(inpStr, i, 1))
        
        If lcl_tmp > 64 And lcl_tmp < 91 Then
        'upper case
            'Convert to string position
            x = (lcl_tmp - 65) * 3 + 1
            
        ElseIf lcl_tmp > 96 And lcl_tmp < 123 Then
        'if lower case
            'Convert to string position
            x = (lcl_tmp - 97) * 3 + (26 * 3) + 1
            
        ElseIf lcl_tmp > 47 And lcl_tmp < 58 Then
        'Numeric
            'Convert to string position
            x = ((lcl_tmp - 48) * 3) + ((26 * 3) * 2) + 1
            
        ElseIf lcl_tmp = 32 Then
        'Space pos.
            'Convert to string position
            'x = (26 * 3) * 2 + 10
            x = Len(Mdl_CTable) - 5
           
        ElseIf lcl_tmp = 35 Then
        '# pos.
            x = Len(Mdl_CTable) - 2
            
        Else
        ' Invalid input
            x = 32
        End If
        
                
        outStr = outStr + Mid(Mdl_CTable, x, 3)
    Next i
    
    ConvertC = outStr
    
    
End Function






Function ValidateUserInfo()
'Validate User information for the different types of FCC
'Note: Becuase we are using C table encoding.  Any length barcodes which are not
'divisible by 3 eg.  31 16 etc will have a 3 appended to the end.
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Dim strlen As Integer
Dim i As Integer

    If (Left$(Lbl_FCC.Caption, 18) = Left$(gbl_FCC_val_59, 18)) Then
        strlen = Len(txtUserInfo)
        
        If strlen < 5 Then
            MsgBox "User information field is shorter than expected, paded with 3s", vbInformation
            For i = strlen + 1 To 5
                txtUserInfo.Text = txtUserInfo.Text + "3"
            Next i
        End If
            
        If strlen > 5 Then
            MsgBox "The User information field is longer than expected." & _
            "  Reducing the size to fit."
            txtUserInfo.Text = Left$(txtUserInfo.Text, 5)
        
        End If
        
    End If


    'Case FCC 62 => 31 length barcode. (Can have 10 User information digits.)
    If (Left$(Lbl_FCC.Caption, 18) = Left$(gbl_FCC_val_62, 18)) Then
        strlen = Len(txtUserInfo)
        
        If strlen < 10 Then
            MsgBox "User information field is shorter than expected, padded with 3s", vbInformation
            For i = strlen + 1 To 10
                txtUserInfo.Text = txtUserInfo.Text + "3"
            Next i
        End If
        
        If strlen > 10 Then
            MsgBox "The User information field is longer than expected." & _
            "  Reducing the size to fit."
            txtUserInfo.Text = Left$(txtUserInfo.Text, 10)
        End If
        
    End If
    
    
End Function





Public Function RSEncode(ByVal k As Integer, ByRef SymbArray() As Integer, ByRef RSArray() As Integer) As Integer
'------------------------------------------------------------------
' This function accepts as inputs the number of input symbols, an
' array where the input symbols are stored and an output array
' where the resulting output symbols are stored.
'------------------------------------------------------------------

    Dim n As Integer, i As Integer, j As Integer
    Dim temp(31) As Integer
    
    'Call RSInit        'Need only called once at the start
    On Error GoTo RSEncode_ErrorHandler
    
    n = k + 4
    '
    ' The temp array is initialised with x^(n-k) m(x).  After
    ' division by g(x), temp will contain the parity symbols,
    ' p(x), in locations 0 to 4. Note that p(x) is the remainder
    ' after the division operation.
    '
    For i = 0 To 3
        temp(i) = 0
    Next i
    
    For i = 4 To n - 1
        temp(i) = SymbArray(n - 1 - i) 'Fill in reversed order
    Next i
    '
    ' Perform the division by the generator polynomial g(x).
    ' This is accomplished using k iterations of long division,
    ' where g(x) times the most significant symbol in the
    ' dividend are subtracted.
    '
    For i = k - 1 To 0 Step -1
        For j = 0 To 4
            temp(i + j) = temp(i + j) Xor mult(gen(j), temp(i + 4))
        Next j
    Next i
    
    
    For i = 0 To 3      ' Fill in the resulting output array
        RSArray(i) = temp(3 - i)
    Next i
    
    RSEncode = 0
    Exit Function
    
RSEncode_ErrorHandler:
    RSEncode = 1
    Exit Function

End Function


Sub RSInit()
'------------------------------------------------------------------
' This procedure initialises all the Reed Solomon generator
' arrays and needs to be called once.
'------------------------------------------------------------------
    Dim primpoly As Integer
    Dim testv As Integer
    Dim prevv As Integer
    Dim nextv As Integer
    Dim i As Integer
    Dim j As Integer
    '
    ' Set up the constants required.  primpoly is the binary
    ' representation of the primitive polynomial used to construct
    ' the Galois field GF(64). Test is used to check when an
    ' element must be reduced modulo primpoly.
    '
    primpoly = 67       ' a**6 + a + 1 where a (alpha) is 2
    testv = 64
    '
    ' The mult[][] array provides lookup table multiplication in
    ' GF(64). The two array indices are the elements to be
    ' multiplied, and the corresponding value is the product.
    ' Mult a field element by 0 is 0 and mult by 1 is itself
    '
    For i = 0 To 63
        mult(0, i) = 0
        mult(1, i) = i
    Next i
    '
    ' Multiplication by elements other than 0 or 1 requires the
    ' corresponding powers of alpha which is a root of primpoly.
    '
    ' Beginning with the zero power of alpha, which is 1,
    ' successive powers of alpha are obtained by shifting to the
    ' left. If the result exceeds 6 bits, then it is reduced modulo
    ' primpoly.  The rows of mult[][] are filled iteratively
    ' according to these powers.  Note that the `powers of alpha'
    ' representation is logarithmic, so that multiplication
    ' requires just an addition.  prev is the previous power of
    ' alpha, and next is the next power.  Because of the above
    ' mentioned property of logarithms, the next row is just the
    ' prev row shifted to the left.
    '
    prevv = 1
    For i = 1 To 63
        nextv = prevv * 2
        If (nextv >= testv) Then
            nextv = nextv Xor primpoly
        End If
        
        For j = 0 To 63
            mult(nextv, j) = mult(prevv, j) * 2
            If mult(nextv, j) >= testv Then
                mult(nextv, j) = mult(nextv, j) Xor primpoly
            End If
        Next j
        
        prevv = nextv
        
    Next i
    
    ' Initialise the generator polynomial
    gen(0) = 48
    gen(1) = 17
    gen(2) = 29
    gen(3) = 30
    gen(4) = 1
    
End Sub





Sub ConvertDecToG3(inpArray() As Integer, ByRef outStr As String)
'Converts parity symbols from integer to a G3 barcode
    Dim i As Integer
    
    outStr = ""
    For i = 0 To 3
        outStr = outStr + Mdl_BarTable(inpArray(i))
    Next i

End Sub

Function BuildBarcode(FCC As String, DPID As String, UI As String) As Integer

'------------------------------------------------------------------
' This function builds the barcode digit string from 3 input
' strings: Format Control Code, DPID and User Information.
'------------------------------------------------------------------

    Dim i As Integer
    Dim j As Integer
    Dim xlen As Integer
    Dim tmpStr As String
    Dim lcl_temp As String
    'Dim RS As New RsClass
    Dim rc As Integer
    Dim paritySymb(0 To 3) As Integer
    Dim parityStr As String
    Dim ret_val As Boolean
    
    'Initialise to false for function return purposes(See calling function for reason)
    BuildBarcode = 2
        
    
    'Assign values to the text string FCC select statements.
    Select Case Left$(FCC, 18)
        'FCC is 11
        Case gbl_FCC_val_11
            FCC = "11"
        'FCC is 59
        Case gbl_FCC_val_59
            FCC = "59"
        'FCC is 62
        Case gbl_FCC_val_62
            FCC = "62"
    End Select
    
    
    'Ensure length of FCC is two only
    FCC = Left(FCC, 2)
    '
    'Validate the user input and reduce the length of UI if
    'necessary
    '
    ret_val = Validate_UI()
    If ret_val = False Then
        BuildBarcode = 2
        GoTo stop_build 'Invalid digit in UI field.
    End If
        
        
    'Convert using N table
    txtFCC2.Text = ConvertN(FCC)
    txtDPID2.Text = ConvertN(DPID)
        
        
    'Assign FCC and DPID to info box.
    txt3.Text = txtFCC2.Text + txtDPID2.Text
   
    
    
    'Assign the UI field to the same box above if applicable.
    If txtUserInfo <> "" Then
        
        If ui_params.UI_type = "C" Then
            'Convert user information using C encoding.
            txtUserInfo2.Text = ConvertC(UI)
        Else
            txtUserInfo2.Text = UI
        End If
        
    ElseIf txtUserInfo2.Text <> "" Then
        txtUserInfo2.Text = ""
    End If
    
    
    'Pad the UI's 2'nd text box with 3's if neccess.
    Pad_UserInformation
    
    
    
    'Assign User info to FCC and DPID
    txt3.Text = txt3.Text + txtUserInfo2.Text
    
    
    
    'No longer need this next section, but will keep it here for posterity!!
    'Pad the concatenation of FCC DPID and UI with 3's if necessary.
    txtPadding2.Text = ""
    Do While (Len(txt3.Text) Mod 3) <> 0
        txt3.Text = txt3.Text + "3"
        txtPadding2.Text = txtPadding2.Text + "3"
    Loop


    
    'Display the string in group of 3's
    xlen = Len(txt3.Text)
    Txt4.Text = ""
    For i = 1 To xlen
        Txt4.Text = Txt4.Text + Mid(txt3.Text, i, 1)
        If (i Mod 3) = 0 Then
            Txt4.Text = Txt4.Text + " "
        End If
    Next i
    
    'Convert into info symbols to be fed into Reed Solomon algo.
    nCodeWord = xlen / 3
    Call ConvertG3ToDec(txt3.Text, ICodeWord())

    txt5.Text = ""
    For i = 0 To nCodeWord - 1
        txt5.Text = txt5.Text + Str(ICodeWord(i)) + "  "
    Next i
    
    'Call Reed Solomon algo to generate 4 error correction symbols
    rc = RSEncode(nCodeWord, ICodeWord, paritySymb)
    If rc <> 0 Then
        MsgBox ("Problem with Reed Solomon algorithm")
        BuildBarcode = 2
        Exit Function
    End If
    
    txt6.Text = ""
    For i = 0 To 3
        txt6.Text = txt6.Text + Str(paritySymb(i)) + "  "
    Next i
    
    'Convert RS symbols from decimal to barcode digit form
    Call ConvertDecToG3(paritySymb(), parityStr)
    txt7.Text = ""
    For i = 0 To 3
        txt7.Text = txt7.Text + Mid(parityStr, (i * 3) + 1, 3) + "  "
    Next i
    
    txt8.Text = parityStr
    
    txt9.Text = parityStr
    txt9.Text = txt3.Text
    txtStartDigits.Text = "13"
    txtStopDigits.Text = "13"
    txtBCStr = txtStartDigits.Text + txt9.Text + txt8.Text + txtStopDigits.Text
    
    Call DisplayBarcode(txtBCStr)           'Display barcode graphically
    
    BuildBarcode = 0

stop_build:
    'do nothing (There was an Invalid digit in UI field. )
    

End Function

Function Validate_UI() As Boolean
'This funciton validates the User information for the type of FCC and UI field.
'The UI field should conform to the selected digit type and length.
' The options for UI field are bars and chars.
' The options for the FCC are to numerous to mention.

    Validate_UI = True
    
    Dim lcl_txt_UI As String
    Dim lcl_iLen As Integer
    Dim i As Integer
    Dim lcl_temp As String
    Dim Upper_case_flag As Boolean
    Dim Lower_case_flag As Boolean
    Dim Num_case_flag As Boolean
    Dim Invalid_case_flag As Boolean
    Dim Greatest_Num_Val As Integer

    'Define carriage return line feed
    Dim CRLF As String
    CRLF = Chr$(13) & Chr$(10)
    
    
    'Initialise variables
    Upper_case_flag = False
    Lower_case_flag = False
    Num_case_flag = False
    Invalid_case_flag = False
    Greatest_Num_Val = 0
    lcl_txt_UI = txtUserInfo
    
    lcl_iLen = Len(lcl_txt_UI)
    
    
    
        
    'Get UI string characters one by one and assign flags.
    For i = 1 To lcl_iLen
        'get next sring val
        lcl_temp = Asc(Mid(lcl_txt_UI, i, 1))
        
        If lcl_temp > 64 And lcl_temp < 91 Then
        'upper case
            Upper_case_flag = True
        ElseIf lcl_temp > 96 And lcl_temp < 123 Then
        'lower case
            Lower_case_flag = True
        ElseIf lcl_temp > 47 And lcl_temp < 58 Then
        'Numeric
            Num_case_flag = True
            'Assign the greatest number found to the temp holder
            If Greatest_Num_Val < lcl_temp Then
                lcl_temp = Greatest_Num_Val
            End If
        ElseIf lcl_temp = 32 Then
        'Space pos.
            'Use lower case flag
            Lower_case_flag = True
        ElseIf lcl_temp = 35 Then
            'Use lower case flag
            Lower_case_flag = True
        Else
            'Invalid digit
            Invalid_case_flag = True
        End If
        
    Next i
    
   
    'Get length of user info field
    ui_params.UI_str_len = Len(txtUserInfo)

    'presentation version only has c conversion for the UI field.
    'Hardcoding the UI type
    ui_params.UI_type = "C"
    'Read above comments

    'Test the cases for valid input
    'Read above comments
    Select Case ui_params.UI_type
                
      Case "B"
        'UI should only contain 0,1,2,3 (Valid bar states)
        If Num_case_flag = True And Lower_case_flag = False And Upper_case_flag = False And Invalid_case_flag = False Then
            If Greatest_Num_Val > 3 Then
                MsgBox "Error in the User Information field" & CRLF + _
                       "Usage : digits restricted to {0,1,2,3}"
                Validate_UI = False
            End If
                       
        Else
                MsgBox "User Information field usage {0,1,2,3}"
                Validate_UI = False
        End If
        'Validate the size of the user info field.
        'Reduce size to fit if neccesary
        If ui_params.UI_str_len > ui_params.UI_len Then
                 MsgBox "User information field is longer than expected." + _
                       "  Reducing size to fit."
                    'Reduce size to fit the selected lenght.
                    txtUserInfo = Left$(txtUserInfo, ui_params.UI_len)
                 Validate_UI = False
        End If
             
      Case "C"
         'UI can contain Numbers Chars and specific digits.
            If Invalid_case_flag = True Then
                  MsgBox "Error in the user information field." & CRLF & CRLF + _
                         "The allowable characters are :" & CRLF + _
                         "   Alphabetic characters, upper and lower case (A-Z,a-z)" & CRLF + _
                         "   Digits (0-9)" & CRLF + _
                         "   Spaces ( ) " & CRLF + _
                         "   Hashes (#)"
                         
                         
                         
                  Validate_UI = False
            End If
    
            
         'Set the maximum size field for C encoding  (16=>5  31=>10)
            If ui_params.UI_str_len <> 0 Then
                ui_params.UI_str_len = (ui_params.UI_str_len - 1) / 3
            
            End If
            
          'Validate the size of the user info field.
          'Reduce size to fit if neccesary
            If ui_params.UI_str_len > ui_params.UI_len Then
              MsgBox "User information field is longer than expected." + _
                     "  Reducing size to fit."
                'Reduce size to fit the selected lenght.
                txtUserInfo = Left$(txtUserInfo, ui_params.UI_len)
                Validate_UI = False
            End If

    
    End Select
    

End Function


Sub Pad_UserInformation()
    'Pad the UI with fille bar values of 3 up to the neccessary length.
    
    Dim ui2_length As Integer
    
    ui2_length = Len(txtUserInfo2.Text)
    
    If ui_params.FCC_type = 59 Then
        'while less than 16
        Do While ui2_length < 16
            ui2_length = ui2_length + 1
            
            txtUserInfo2.Text = txtUserInfo2.Text + "3"
        Loop
        
    ElseIf ui_params.FCC_type = 62 Then
        'while less than 31
        Do While ui2_length < 31
            ui2_length = ui2_length + 1
            txtUserInfo2.Text = txtUserInfo2.Text + "3"
        Loop
        
    End If
    
End Sub



Sub ConvertG3ToDec(ByVal inpStr As String, ByRef outArray() As Integer)
    'Convert a G3 encoded barcode string to an integer array
    Dim i As Integer
    Dim j As Integer
    Dim n As Integer
    Dim tmpStr As String
    
    n = Len(inpStr) / 3
    
    For i = 1 To n
        tmpStr = Mid(inpStr, ((i - 1) * 3) + 1, 3)
        For j = 0 To 63
            If StrComp(Mdl_BarTable(j), tmpStr, 1) = 0 Then
                outArray(i - 1) = j    'Array index starts from 0
                Exit For
            End If
        Next j
    Next i
    
End Sub


Function ConvertN(inpStr As String) As String
' Performs N (G3) encoding of decimal digits
    Dim i As Integer
    Dim x As Integer
    Dim iLen As Integer
    Dim outStr As String
            
    iLen = Len(inpStr)
    outStr = ""
    
    For i = 1 To iLen
        'tmpStr = Mdl_NTable(Mid(inpStr, i, 1)) 'if using array
        x = (Val(Mid(inpStr, i, 1)) * 2) + 1
        outStr = outStr + Mid(Mdl_NTable, x, 2)
    Next i
    
    ConvertN = outStr
    
End Function

Sub DisplayBarcode(BCStr As String)
    '
    ' Produces a graphical representation of the
    ' 4-state barcode
    '
    Dim Gap As Integer
    Dim Wid As Integer
    Dim Ascender As Integer
    Dim Tracker As Integer
    Dim Descender As Integer
    Dim MaxBarLen As Integer
    Dim slen As Integer
    Dim StartPoint As Integer
    Dim c As String
    Dim i As Integer
    Dim x1 As Integer
    Dim x2 As Integer
    Dim y1 As Integer
    Dim y2 As Integer
    Dim PH As Integer
    Dim PW As Integer
    
    PicBC.ScaleMode = 1   ' Set ScaleMode to twip
    PicBC.DrawWidth = 1   ' Set DrawWidth
    PicBC.Cls
    PH = PicBC.Height
    PW = PicBC.Width
    
    Gap = 55
    Wid = 50
    Ascender = 210
    Descender = 210
    Tracker = 160
    MaxBarLen = Ascender + Tracker + Descender
    StartPoint = (PH - MaxBarLen) * 0.32
    
    x1 = 100
    x2 = x1 + Wid
    slen = Len(BCStr)

    For i = 1 To slen
        c = Mid(BCStr, i, 1)
        
        Select Case c
            Case "0"
                y2 = StartPoint + MaxBarLen
                y1 = StartPoint
            Case "1"
                y2 = StartPoint + Ascender + Tracker
                y1 = StartPoint
            Case "2"
                y2 = StartPoint + MaxBarLen
                y1 = StartPoint + Ascender
            Case "3"
                y2 = StartPoint + Ascender + Tracker
                y1 = StartPoint + Ascender
                
        End Select
        PicBC.Line (x1, y1)-(x2, y2), , BF
        
        PicBC.CurrentX = x1
        PicBC.CurrentY = StartPoint + MaxBarLen
        PicBC.Print c
        
        x1 = x1 + Wid + Gap
        x2 = x1 + Wid
    Next i

'Need to set focus to this window and enable copies and pastes.
'PicBC.SetData c

End Sub

Sub Initialise()

'Declarations
Dim i As Integer, j As Integer, k As Integer
Dim BarTable_Index As Integer


'Check number of items in list.  Set index to first item.
If Lst_FCC.ListCount > 0 Then Lbl_FCC.Caption = Lst_FCC.List(0)
txtPadding2.Text = ""
'N table array of 00 01 etc.
Mdl_NTable = "00010210111220212230"

'C table array of 000 001 etc.
Mdl_CTable = "000001002010011012020021022100101102110111112120121122200201202210211212220221" + _
             "023030031032033103113123130131132133203213223230231232233303313323330331332333" + _
             "222300301302310311312320321322003013"
    
    BarTable_Index = 0
    'Initialise the Bar Table array  (Array of 000 001 002 003 100 etc)
    For i = 0 To 3
        For j = 0 To 3
            For k = 0 To 3
                Mdl_BarTable(BarTable_Index) = Trim$(Str$(i)) & Trim$(Str$(j)) & Trim$(Str$(k))
                BarTable_Index = BarTable_Index + 1
            Next k
        Next j
    Next i
    
    
End Sub


Sub SetTextFields(Vis As Boolean)

    txtPadding2.Visible = Vis
    txt3.Visible = Vis
    Txt4.Visible = Vis
    txt5.Visible = Vis
    txt6.Visible = Vis
    txt7.Visible = Vis
    txt8.Visible = Vis
    txt9.Visible = Vis
    'txt10.Visible = Vis
    txtRS.Visible = Vis
    txtStartDigits.Visible = Vis
    txtStopDigits.Visible = Vis
    txtBCStr.Visible = Vis
    PicBC.Visible = Vis

End Sub



Function ValidateInputs() As Boolean

    Dim i As Integer
    Dim c As String
    Dim strlen As Integer
    Dim Response As Integer
        
    ValidateInputs = True
        
    If Len(txtDPID.Text) <> 8 Then
        MsgBox ("Invalid Sorting Code : Sorting Code must be all digits and exactly eight digits long.")
        txtDPID.SetFocus
        ValidateInputs = False
    
    'Check if DPID contains only numeric
    ElseIf Not IsNumeric(txtDPID.Text) Then
    
        MsgBox ("Invalid Sorting Code : Sorting Code must be all digits and exactly eight digits long.")
        txtDPID.SetFocus
        ValidateInputs = False
    End If
    
    
    'User information is validated in the ValidateUserInfo function.
    
End Function

Function ValidateBCStringAsDigit(BCStr As String) As Boolean
'Function ValidateBCStringAsDigit checks if the string is numeric.


    Dim i As Integer
    Dim slen As Integer
    Dim c As String
    
    ValidateBCStringAsDigit = True
    slen = Len(BCStr)
    
    
    For i = 1 To slen
        c = Mid(BCStr, i, 1)
        If (Not IsNumeric(c)) Or (Val(c) < 0 Or Val(c) > 3) Then
            MsgBox ("Invalid character in User Information field")
            ValidateBCStringAsDigit = False
            Exit For
        End If
    Next i

    

End Function


Private Sub Cmd_FCC_Click()

    Lst_FCC.Visible = True
    Lst_FCC.SetFocus
    
End Sub

Private Sub cmdBuild_Click()

    Dim rc As Integer
    
    Call SetTextFields(True)
    
    If ValidateInputs() Then
        rc = BuildBarcode(Lbl_FCC.Caption, txtDPID, txtUserInfo)
        'check rc?
    'Else
        'msgbox?
    End If


    
End Sub





Private Sub cmdClear_Click()

    txtDPID.Text = ""
    txtUserInfo.Text = ""
    txtFCC2.Text = ""
    txtDPID2.Text = ""
    txtUserInfo2.Text = ""
    txtPadding2.Text = ""
    txt3.Text = ""
    Txt4.Text = ""
    txt5.Text = ""
    txt6.Text = ""
    txt7.Text = ""
    txt8.Text = ""
    txt9.Text = ""
    'txt10.Text = ""
    txtStartDigits = ""
    txtStopDigits = ""
    txtBCStr.Text = ""
    PicBC.Cls
    
    txtDPID.SetFocus
    
End Sub

Private Sub cmdStep_Click()

    Dim rc As Integer
    Dim StepText As String
    
    'Initialise so that only if fullly validated the
    'barcode can be built.
    rc = 2
    
    
    If ValidateInputs() Then
        rc = BuildBarcode(Lbl_FCC.Caption, txtDPID, txtUserInfo)
    End If
    
    
    If rc <> 0 Then
        Exit Sub
    End If
    
    
    Call SetTextFields(False)
    cmdBuild.Visible = False
    cmdStep.Visible = False
    cmdClear.Visible = False
    
    
    frmStep.Show vbModal
    
    
End Sub


Private Sub Form_Activate()
    
    txtDPID.SetFocus
    

End Sub

Private Sub Form_Load()

    If App.PrevInstance Then
        MsgBox ("The application's already running")
        End
    End If
    
    Call Initialise
    Call RSInit         'Init the Reed Solomon algo
       
End Sub

Private Sub List1_Click()

End Sub

Private Sub Lst_FCC_Click()

    Lbl_FCC.Caption = Lst_FCC
    Lst_FCC.Visible = False

    Dim x As ColorConstants
    x = txtUserInfo.BackColor
    
    Select Case Left$(Lst_FCC, 18)
    
        Case Is = Left$(gbl_FCC_val_11, 18), "87", "45", "92" '37-CUST,37-ROUT,37-REPL,37-REDI
            txtUserInfo.Text = ""
            txtUserInfo2.Text = ""
            txtUserInfo.Enabled = False
            txtUserInfo.BackColor = &H8000000F
            txtUserInfo2.Visible = False
            ui_params.UI_len = 0
            ui_params.FCC_type = 11
        
        Case Is = Left$(gbl_FCC_val_59, 18)          '52-FF-MET
            txtUserInfo.MaxLength = 5
            If Len(txtUserInfo) > 16 Then
                txtUserInfo = Mid(txtUserInfo, 1, 16)
                txtUserInfo2 = txtUserInfo
            End If
            txtUserInfo.Enabled = True
            txtUserInfo.BackColor = &HFFFFC0
            txtUserInfo2.Visible = True
            ui_params.UI_len = 16
            ui_params.FCC_type = 59
            
        Case Is = Left$(gbl_FCC_val_62, 18), "44"    '67-FF-MET, 67-FF-MAN
            txtUserInfo.MaxLength = 10
            txtUserInfo.Enabled = True
            txtUserInfo.BackColor = &HFFFFC0
            txtUserInfo2.Visible = True
            ui_params.UI_len = 31
            ui_params.FCC_type = 62
    End Select

End Sub

Private Sub Lst_FCC_LostFocus()

    Lst_FCC.Visible = False
    
End Sub


Private Sub mnuAbout_Click()

    frmAbout.Show
    
End Sub





Private Sub mnuExit_Click()
    End
End Sub


Private Sub mnuPrint_Click()
    
    PrintForm
    
End Sub

Private Sub mnuRS_Click()

    frmRS.Show vbModal
    
End Sub

Private Sub mnuHelpIndex_Click()

End Sub

Private Sub txtDPID_Change()
    'Call BuildBarcode
End Sub


Private Sub txtUserInfo_Change()
    'Call BuildBarcode
End Sub


Private Sub val_Change()

End Sub


